$(document).ready(function () {
    // define variables
    let stream_type = $('#stream_type').attr('type');
    let live_stream = $('#my_video_1').find('Source:first').attr('src');
    //check if we have live stream then play it or play server stream instade
    setupHypirdLink(live_stream,stream_type)

    //do last check every 30 secound
    setInterval(function () {
        setupHypirdLink(live_stream,stream_type)
    }, 30000);

    //---------------------------------- Functions ------------------------

    // function set server stream links depends on bit rate type multi or single
    function getServerStreamLink(live_stream,stream_type){
        if (stream_type == 'multi'){
            let newstring = live_stream.split('/multi_live/').shift();
            let server_stream = newstring+"/multi_web/play.m3u8";
            return server_stream;
        }else{
            let newstring = live_stream.split('/live/').shift();
            let server_stream = newstring+"/stream/play.m3u8";
            return server_stream;
        }
    }

    // function that set the player link
    function setupHypirdLink(live_stream,stream_type){
        $.get(live_stream, function () {
            var mypalyer = videojs('#my_video_1');
            if (mypalyer.src() != live_stream) {
                mypalyer.src([
                    {type: "application/x-mpegURL", src: live_stream},
                ]);
            }
        }).fail(function () {
            var mypalyer = videojs('#my_video_1');
            let server_stream = getServerStreamLink(live_stream,stream_type);
            if (mypalyer.src() != server_stream) {
                mypalyer.src([
                    {type: "application/x-mpegURL", src: server_stream},
                ]);
            }
        });
    }

});
