-- MySQL dump 10.13  Distrib 5.7.32, for Linux (x86_64)
--
-- Host: localhost    Database: vdopanel_new2
-- ------------------------------------------------------
-- Server version	5.7.32

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `admincodes`
--

DROP TABLE IF EXISTS `admincodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admincodes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `target_id` int(11) NOT NULL DEFAULT '1',
  `type` varchar(255) NOT NULL DEFAULT 'admin',
  `code` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admincodes`
--

LOCK TABLES `admincodes` WRITE;
/*!40000 ALTER TABLE `admincodes` DISABLE KEYS */;
/*!40000 ALTER TABLE `admincodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aliaslinks`
--

DROP TABLE IF EXISTS `aliaslinks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aliaslinks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) NOT NULL,
  `alias_domain` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aliaslinks`
--

LOCK TABLES `aliaslinks` WRITE;
/*!40000 ALTER TABLE `aliaslinks` DISABLE KEYS */;
/*!40000 ALTER TABLE `aliaslinks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `apicodes`
--

DROP TABLE IF EXISTS `apicodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `apicodes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `apicodes`
--

LOCK TABLES `apicodes` WRITE;
/*!40000 ALTER TABLE `apicodes` DISABLE KEYS */;
INSERT INTO `apicodes` VALUES (1,'','2020-08-18 12:51:12','2020-10-15 18:45:08');
/*!40000 ALTER TABLE `apicodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `backups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_status` enum('0','1') NOT NULL DEFAULT '0',
  `local_daily` enum('0','1') NOT NULL DEFAULT '0',
  `local_weekly` enum('0','1') NOT NULL DEFAULT '0',
  `remote_status` enum('0','1') NOT NULL DEFAULT '0',
  `remote_daily` enum('0','1') NOT NULL DEFAULT '0',
  `remote_weekly` enum('0','1') NOT NULL DEFAULT '0',
  `server_ip` varchar(255) NOT NULL,
  `server_port` int(11) NOT NULL DEFAULT '22',
  `server_user` varchar(255) NOT NULL,
  `server_password` varchar(255) NOT NULL,
  `server_destination` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` VALUES (1,'0','0','1','0','0','1','',22,'','','','2020-10-27 11:57:04','2020-11-09 17:14:41');
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `brandings`
--

DROP TABLE IF EXISTS `brandings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brandings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `logo` varchar(255) NOT NULL DEFAULT 'uploads/brands/logo.png',
  `domain` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `brandings`
--

LOCK TABLES `brandings` WRITE;
/*!40000 ALTER TABLE `brandings` DISABLE KEYS */;
INSERT INTO `brandings` VALUES (1,1,'uploads/brands/1593963635.png','demo.vdopanel.com','2020-07-29 14:20:05','2020-07-29 12:20:05');
/*!40000 ALTER TABLE `brandings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `broadcastercodes`
--

DROP TABLE IF EXISTS `broadcastercodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `broadcastercodes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `broadcaster_id` int(11) NOT NULL,
  `code` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `broadcastercodes`
--

LOCK TABLES `broadcastercodes` WRITE;
/*!40000 ALTER TABLE `broadcastercodes` DISABLE KEYS */;
/*!40000 ALTER TABLE `broadcastercodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `broadcasters`
--

DROP TABLE IF EXISTS `broadcasters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `broadcasters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `remember_token` varchar(255) DEFAULT NULL,
  `B_type` int(11) NOT NULL,
  `channel_name` varchar(255) NOT NULL,
  `http_port` int(11) DEFAULT NULL,
  `rtmp_port` int(11) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `ftp` varchar(255) DEFAULT NULL,
  `rtmp_auth` varchar(255) DEFAULT NULL,
  `logo_wm` varchar(255) DEFAULT NULL,
  `logowm_status` int(11) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '1',
  `start_stop` int(11) NOT NULL DEFAULT '1',
  `start_stop_webtv` int(11) NOT NULL DEFAULT '1',
  `viewers_limit` int(11) NOT NULL,
  `bitrate` int(11) NOT NULL,
  `m_bitrate` int(11) NOT NULL,
  `fb_stream` int(11) NOT NULL DEFAULT '0',
  `youtube_stream` int(11) NOT NULL DEFAULT '0',
  `twitch_stream` int(11) NOT NULL DEFAULT '0',
  `pscp_stream` int(11) NOT NULL DEFAULT '0',
  `dmotion_stream` int(11) NOT NULL DEFAULT '0',
  `custom_stream` int(11) NOT NULL DEFAULT '0',
  `wm_brandlogo` int(11) NOT NULL DEFAULT '1',
  `vdo_directory` int(11) NOT NULL DEFAULT '0',
  `station_storage` int(11) NOT NULL,
  `traffic_month` int(11) NOT NULL,
  `traffic_hold` int(11) NOT NULL DEFAULT '0',
  `playerpic` varchar(255) NOT NULL DEFAULT 'background-1.jpg',
  `chat` int(11) NOT NULL DEFAULT '0',
  `chat_msg` int(11) NOT NULL DEFAULT '100',
  `wm_position` varchar(255) NOT NULL DEFAULT 'topright',
  `wm_size` int(11) NOT NULL DEFAULT '0',
  `ip_lock` int(11) NOT NULL DEFAULT '0',
  `loadb` int(11) NOT NULL DEFAULT '0',
  `stream_type_admin` int(11) NOT NULL DEFAULT '0',
  `stream_type` varchar(250) NOT NULL DEFAULT 'single',
  `stream_multi` varchar(250) NOT NULL DEFAULT '0',
  `restream_record` int(11) NOT NULL DEFAULT '0',
  `timezone` varchar(255) NOT NULL DEFAULT 'UTC',
  `lang` varchar(50) NOT NULL DEFAULT 'English - English',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `broadcasters`
--

LOCK TABLES `broadcasters` WRITE;
/*!40000 ALTER TABLE `broadcasters` DISABLE KEYS */;
/*!40000 ALTER TABLE `broadcasters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `channels`
--

DROP TABLE IF EXISTS `channels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `channels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `broadcaster_id` int(11) NOT NULL,
  `password` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `country` varchar(255) NOT NULL,
  `address` varchar(255) DEFAULT NULL,
  `logo` varchar(255) NOT NULL,
  `genre` varchar(255) NOT NULL DEFAULT 'games',
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY `id` (`id`),
  KEY `id_2` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `channels`
--

LOCK TABLES `channels` WRITE;
/*!40000 ALTER TABLE `channels` DISABLE KEYS */;
/*!40000 ALTER TABLE `channels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `comments`
--

DROP TABLE IF EXISTS `comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `broadcaster_id` int(11) NOT NULL,
  `user_name` varchar(255) NOT NULL,
  `body` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `brod_id_f1` (`broadcaster_id`),
  CONSTRAINT `brod_id_f1` FOREIGN KEY (`broadcaster_id`) REFERENCES `broadcasters` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `comments`
--

LOCK TABLES `comments` WRITE;
/*!40000 ALTER TABLE `comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `countries` (
  `countrycode` char(3) NOT NULL,
  `countryname` varchar(200) NOT NULL,
  `code` char(2) DEFAULT NULL,
  PRIMARY KEY (`countrycode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES ('ABW','Aruba','AW'),('AFG','Afghanistan','AF'),('AGO','Angola','AO'),('AIA','Anguilla','AI'),('ALA','Åland','AX'),('ALB','Albania','AL'),('AND','Andorra','AD'),('ARE','United Arab Emirates','AE'),('ARG','Argentina','AR'),('ARM','Armenia','AM'),('ASM','American Samoa','AS'),('ATA','Antarctica','AQ'),('ATF','French Southern Territories','TF'),('ATG','Antigua and Barbuda','AG'),('AUS','Australia','AU'),('AUT','Austria','AT'),('AZE','Azerbaijan','AZ'),('BDI','Burundi','BI'),('BEL','Belgium','BE'),('BEN','Benin','BJ'),('BES','Bonaire','BQ'),('BFA','Burkina Faso','BF'),('BGD','Bangladesh','BD'),('BGR','Bulgaria','BG'),('BHR','Bahrain','BH'),('BHS','Bahamas','BS'),('BIH','Bosnia and Herzegovina','BA'),('BLM','Saint Barthélemy','BL'),('BLR','Belarus','BY'),('BLZ','Belize','BZ'),('BMU','Bermuda','BM'),('BOL','Bolivia','BO'),('BRA','Brazil','BR'),('BRB','Barbados','BB'),('BRN','Brunei','BN'),('BTN','Bhutan','BT'),('BVT','Bouvet Island','BV'),('BWA','Botswana','BW'),('CAF','Central African Republic','CF'),('CAN','Canada','CA'),('CCK','Cocos [Keeling] Islands','CC'),('CHE','Switzerland','CH'),('CHL','Chile','CL'),('CHN','China','CN'),('CIV','Ivory Coast','CI'),('CMR','Cameroon','CM'),('COD','Democratic Republic of the Congo','CD'),('COG','Republic of the Congo','CG'),('COK','Cook Islands','CK'),('COL','Colombia','CO'),('COM','Comoros','KM'),('CPV','Cape Verde','CV'),('CRI','Costa Rica','CR'),('CUB','Cuba','CU'),('CUW','Curacao','CW'),('CXR','Christmas Island','CX'),('CYM','Cayman Islands','KY'),('CYP','Cyprus','CY'),('CZE','Czech Republic','CZ'),('DEU','Germany','DE'),('DJI','Djibouti','DJ'),('DMA','Dominica','DM'),('DNK','Denmark','DK'),('DOM','Dominican Republic','DO'),('DZA','Algeria','DZ'),('ECU','Ecuador','EC'),('EGY','Egypt','EG'),('ERI','Eritrea','ER'),('ESH','Western Sahara','EH'),('ESP','Spain','ES'),('EST','Estonia','EE'),('ETH','Ethiopia','ET'),('FIN','Finland','FI'),('FJI','Fiji','FJ'),('FLK','Falkland Islands','FK'),('FRA','France','FR'),('FRO','Faroe Islands','FO'),('FSM','Micronesia','FM'),('GAB','Gabon','GA'),('GBR','United Kingdom','GB'),('GEO','Georgia','GE'),('GGY','Guernsey','GG'),('GHA','Ghana','GH'),('GIB','Gibraltar','GI'),('GIN','Guinea','GN'),('GLP','Guadeloupe','GP'),('GMB','Gambia','GM'),('GNB','Guinea-Bissau','GW'),('GNQ','Equatorial Guinea','GQ'),('GRC','Greece','GR'),('GRD','Grenada','GD'),('GRL','Greenland','GL'),('GTM','Guatemala','GT'),('GUF','French Guiana','GF'),('GUM','Guam','GU'),('GUY','Guyana','GY'),('HKG','Hong Kong','HK'),('HMD','Heard Island and McDonald Islands','HM'),('HND','Honduras','HN'),('HRV','Croatia','HR'),('HTI','Haiti','HT'),('HUN','Hungary','HU'),('IDN','Indonesia','ID'),('IMN','Isle of Man','IM'),('IND','India','IN'),('IOT','British Indian Ocean Territory','IO'),('IRL','Ireland','IE'),('IRN','Iran','IR'),('IRQ','Iraq','IQ'),('ISL','Iceland','IS'),('ISR','Israel','IL'),('ITA','Italy','IT'),('JAM','Jamaica','JM'),('JEY','Jersey','JE'),('JOR','Jordan','JO'),('JPN','Japan','JP'),('KAZ','Kazakhstan','KZ'),('KEN','Kenya','KE'),('KGZ','Kyrgyzstan','KG'),('KHM','Cambodia','KH'),('KIR','Kiribati','KI'),('KNA','Saint Kitts and Nevis','KN'),('KOR','South Korea','KR'),('KWT','Kuwait','KW'),('LAO','Laos','LA'),('LBN','Lebanon','LB'),('LBR','Liberia','LR'),('LBY','Libya','LY'),('LCA','Saint Lucia','LC'),('LIE','Liechtenstein','LI'),('LKA','Sri Lanka','LK'),('LSO','Lesotho','LS'),('LTU','Lithuania','LT'),('LUX','Luxembourg','LU'),('LVA','Latvia','LV'),('MAC','Macao','MO'),('MAF','Saint Martin','MF'),('MAR','Morocco','MA'),('MCO','Monaco','MC'),('MDA','Moldova','MD'),('MDG','Madagascar','MG'),('MDV','Maldives','MV'),('MEX','Mexico','MX'),('MHL','Marshall Islands','MH'),('MKD','Macedonia','MK'),('MLI','Mali','ML'),('MLT','Malta','MT'),('MMR','Myanmar [Burma]','MM'),('MNE','Montenegro','ME'),('MNG','Mongolia','MN'),('MNP','Northern Mariana Islands','MP'),('MOZ','Mozambique','MZ'),('MRT','Mauritania','MR'),('MSR','Montserrat','MS'),('MTQ','Martinique','MQ'),('MUS','Mauritius','MU'),('MWI','Malawi','MW'),('MYS','Malaysia','MY'),('MYT','Mayotte','YT'),('NAM','Namibia','NA'),('NCL','New Caledonia','NC'),('NER','Niger','NE'),('NFK','Norfolk Island','NF'),('NGA','Nigeria','NG'),('NIC','Nicaragua','NI'),('NIU','Niue','NU'),('NLD','Netherlands','NL'),('NOR','Norway','NO'),('NPL','Nepal','NP'),('NRU','Nauru','NR'),('NZL','New Zealand','NZ'),('OMN','Oman','OM'),('PAK','Pakistan','PK'),('PAN','Panama','PA'),('PCN','Pitcairn Islands','PN'),('PER','Peru','PE'),('PHL','Philippines','PH'),('PLW','Palau','PW'),('PNG','Papua New Guinea','PG'),('POL','Poland','PL'),('PRI','Puerto Rico','PR'),('PRK','North Korea','KP'),('PRT','Portugal','PT'),('PRY','Paraguay','PY'),('PSE','Palestine','PS'),('PYF','French Polynesia','PF'),('QAT','Qatar','QA'),('REU','Réunion','RE'),('ROU','Romania','RO'),('RUS','Russia','RU'),('RWA','Rwanda','RW'),('SAU','Saudi Arabia','SA'),('SDN','Sudan','SD'),('SEN','Senegal','SN'),('SGP','Singapore','SG'),('SGS','South Georgia and the South Sandwich Islands','GS'),('SHN','Saint Helena','SH'),('SJM','Svalbard and Jan Mayen','SJ'),('SLB','Solomon Islands','SB'),('SLE','Sierra Leone','SL'),('SLV','El Salvador','SV'),('SMR','San Marino','SM'),('SOM','Somalia','SO'),('SPM','Saint Pierre and Miquelon','PM'),('SRB','Serbia','RS'),('SSD','South Sudan','SS'),('STP','São Tomé and Príncipe','ST'),('SUR','Suriname','SR'),('SVK','Slovakia','SK'),('SVN','Slovenia','SI'),('SWE','Sweden','SE'),('SWZ','Swaziland','SZ'),('SXM','Sint Maarten','SX'),('SYC','Seychelles','SC'),('SYR','Syria','SY'),('TCA','Turks and Caicos Islands','TC'),('TCD','Chad','TD'),('TGO','Togo','TG'),('THA','Thailand','TH'),('TJK','Tajikistan','TJ'),('TKL','Tokelau','TK'),('TKM','Turkmenistan','TM'),('TLS','East Timor','TL'),('TON','Tonga','TO'),('TTO','Trinidad and Tobago','TT'),('TUN','Tunisia','TN'),('TUR','Turkey','TR'),('TUV','Tuvalu','TV'),('TWN','Taiwan','TW'),('TZA','Tanzania','TZ'),('UGA','Uganda','UG'),('UKR','Ukraine','UA'),('UMI','U.S. Minor Outlying Islands','UM'),('URY','Uruguay','UY'),('USA','United States','US'),('UZB','Uzbekistan','UZ'),('VAT','Vatican City','VA'),('VCT','Saint Vincent and the Grenadines','VC'),('VEN','Venezuela','VE'),('VGB','British Virgin Islands','VG'),('VIR','U.S. Virgin Islands','VI'),('VNM','Vietnam','VN'),('VUT','Vanuatu','VU'),('WLF','Wallis and Futuna','WF'),('WSM','Samoa','WS'),('XKX','Kosovo','XK'),('YEM','Yemen','YE'),('ZAF','South Africa','ZA'),('ZMB','Zambia','ZM'),('ZWE','Zimbabwe','ZW');
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `currentloginips`
--

DROP TABLE IF EXISTS `currentloginips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currentloginips` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` enum('admin','reseller','broadcaster') NOT NULL DEFAULT 'admin',
  `user_id` int(11) DEFAULT NULL,
  `login_type` enum('normal','login-as') NOT NULL DEFAULT 'normal',
  `ip` varchar(255) DEFAULT NULL,
  `login_type_ip` varchar(255) DEFAULT NULL,
  `login_type_status` enum('0','1') NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `currentloginips`
--

LOCK TABLES `currentloginips` WRITE;
/*!40000 ALTER TABLE `currentloginips` DISABLE KEYS */;
/*!40000 ALTER TABLE `currentloginips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_managers`
--

DROP TABLE IF EXISTS `file_managers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_managers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `broadcaster_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_managers`
--

LOCK TABLES `file_managers` WRITE;
/*!40000 ALTER TABLE `file_managers` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_managers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `files`
--

DROP TABLE IF EXISTS `files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `broadcaster_id` int(11) NOT NULL,
  `file` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `files`
--

LOCK TABLES `files` WRITE;
/*!40000 ALTER TABLE `files` DISABLE KEYS */;
/*!40000 ALTER TABLE `files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jingle`
--

DROP TABLE IF EXISTS `jingle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jingle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `broadcaster_id` int(11) NOT NULL,
  `playlist_id` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `jtype` int(11) NOT NULL,
  `pnumber` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `broadcaster_id` (`broadcaster_id`) USING BTREE,
  KEY `playlist_id` (`playlist_id`),
  CONSTRAINT `broadid` FOREIGN KEY (`broadcaster_id`) REFERENCES `broadcasters` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `playlid` FOREIGN KEY (`playlist_id`) REFERENCES `playlists` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jingle`
--

LOCK TABLES `jingle` WRITE;
/*!40000 ALTER TABLE `jingle` DISABLE KEYS */;
/*!40000 ALTER TABLE `jingle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `live_settings`
--

DROP TABLE IF EXISTS `live_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `live_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `broadcaster_id` int(11) NOT NULL,
  `ip` varchar(255) NOT NULL DEFAULT 'no-ip',
  `bitrate` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `broadcaster_id` (`broadcaster_id`),
  CONSTRAINT `live_settings_ibfk_1` FOREIGN KEY (`broadcaster_id`) REFERENCES `broadcasters` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `live_settings`
--

LOCK TABLES `live_settings` WRITE;
/*!40000 ALTER TABLE `live_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `live_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `loadbalancers`
--

DROP TABLE IF EXISTS `loadbalancers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `loadbalancers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `serv_name` varchar(250) CHARACTER SET utf8 NOT NULL,
  `serv_user` varchar(250) CHARACTER SET utf8 NOT NULL,
  `serv_ip` varchar(250) CHARACTER SET utf8 NOT NULL,
  `serv_port` int(11) NOT NULL,
  `weight` int(11) NOT NULL DEFAULT '1',
  `default_all` int(11) NOT NULL DEFAULT '0',
  `setup_status` int(11) NOT NULL DEFAULT '3',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `loadbalancers`
--

LOCK TABLES `loadbalancers` WRITE;
/*!40000 ALTER TABLE `loadbalancers` DISABLE KEYS */;
/*!40000 ALTER TABLE `loadbalancers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `logincode_resellers`
--

DROP TABLE IF EXISTS `logincode_resellers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `logincode_resellers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reseller_id` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `logincode_resellers`
--

LOCK TABLES `logincode_resellers` WRITE;
/*!40000 ALTER TABLE `logincode_resellers` DISABLE KEYS */;
/*!40000 ALTER TABLE `logincode_resellers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `logincodes`
--

DROP TABLE IF EXISTS `logincodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `logincodes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `broadcaster_id` int(11) NOT NULL,
  `code` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `logincodes`
--

LOCK TABLES `logincodes` WRITE;
/*!40000 ALTER TABLE `logincodes` DISABLE KEYS */;
/*!40000 ALTER TABLE `logincodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2019_08_19_000000_create_failed_jobs_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_resets`
--

DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_resets`
--

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `playlists`
--

DROP TABLE IF EXISTS `playlists`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `playlists` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `broadcaster_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `Mode` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `tags` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `broadcaster_id` (`broadcaster_id`),
  CONSTRAINT `playlists_ibfk_1` FOREIGN KEY (`broadcaster_id`) REFERENCES `broadcasters` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `playlists`
--

LOCK TABLES `playlists` WRITE;
/*!40000 ALTER TABLE `playlists` DISABLE KEYS */;
/*!40000 ALTER TABLE `playlists` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reseller_broadcasters`
--

DROP TABLE IF EXISTS `reseller_broadcasters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reseller_broadcasters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reseller_id` int(11) NOT NULL,
  `broadcaster_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `reseller_id` (`reseller_id`),
  KEY `broadcaster_id` (`broadcaster_id`),
  CONSTRAINT `brod1` FOREIGN KEY (`broadcaster_id`) REFERENCES `broadcasters` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `reseller1` FOREIGN KEY (`reseller_id`) REFERENCES `resellers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reseller_broadcasters`
--

LOCK TABLES `reseller_broadcasters` WRITE;
/*!40000 ALTER TABLE `reseller_broadcasters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reseller_broadcasters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resellers`
--

DROP TABLE IF EXISTS `resellers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `resellers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `remember_token` varchar(255) DEFAULT NULL,
  `company_name` varchar(255) NOT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `account_limits` int(11) NOT NULL DEFAULT '0',
  `viewers_limit` int(11) NOT NULL,
  `fb_stream` int(11) NOT NULL DEFAULT '0',
  `youtube_stream` int(11) NOT NULL DEFAULT '0',
  `twitch_stream` int(11) NOT NULL DEFAULT '0',
  `pscp_stream` int(11) NOT NULL DEFAULT '0',
  `dmotion_stream` int(11) NOT NULL DEFAULT '0',
  `custom_stream` int(11) NOT NULL DEFAULT '0',
  `vdo_directory` int(11) NOT NULL DEFAULT '0',
  `station_storage` int(11) NOT NULL,
  `traffic_month` int(11) NOT NULL,
  `traffic_hold` int(11) NOT NULL DEFAULT '0',
  `stream_type` varchar(250) NOT NULL DEFAULT 'single',
  `timezone` varchar(255) NOT NULL DEFAULT 'UTC',
  `logo` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `lang` varchar(50) NOT NULL DEFAULT 'English - English',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resellers`
--

LOCK TABLES `resellers` WRITE;
/*!40000 ALTER TABLE `resellers` DISABLE KEYS */;
/*!40000 ALTER TABLE `resellers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'broadcasters','2021-01-27 14:02:58',NULL),(2,'broadcasters_create','2021-01-27 14:02:58','2021-01-28 22:15:23'),(3,'resellers','2021-01-27 14:05:06',NULL),(4,'resellers_create','2021-01-27 14:05:06',NULL),(5,'templates','2021-01-27 14:06:19',NULL),(6,'admin','2021-01-27 14:08:22','2021-01-28 22:22:55'),(7,'smtp','2021-01-27 14:09:20','2021-01-28 22:23:21'),(8,'license','2021-01-27 14:09:20','2021-01-28 22:23:37'),(9,'api-config','2021-01-27 14:09:55','2021-01-28 22:24:06'),(10,'branding','2021-01-27 14:10:34',NULL),(11,'backup-config','2021-01-27 14:13:02','2021-01-29 00:59:22'),(12,'backup-scheduling-status','2021-01-27 14:13:02','2021-01-29 01:04:48'),(13,'restore-backup','2021-01-27 14:14:02','2021-01-29 01:10:04'),(14,'manually-backup','2021-01-27 14:14:26','2021-01-29 01:13:47'),(15,'transfer-tool','2021-01-27 14:15:01','2021-01-29 01:16:23'),(16,'restart_service','2021-01-27 14:15:58',NULL),(17,'system-info','2021-01-27 14:17:16',NULL),(18,'check-version','2021-01-27 14:17:16',NULL),(20,'broadcaster_view','2021-02-02 19:30:40',NULL),(21,'broadcaster_edit','2021-02-02 19:30:40',NULL),(22,'broadcaster_delete','2021-02-02 19:31:32',NULL),(23,'broadcaster_status','2021-02-02 19:31:32','2021-02-02 22:12:33'),(24,'reseller_view','2021-02-02 19:30:40',NULL),(25,'reseller_edit','2021-02-02 19:30:40',NULL),(26,'reseller_delete','2021-02-02 19:31:32',NULL),(27,'reseller_status','2021-02-02 19:31:32','2021-02-02 22:12:45'),(28,'broadcaster_login_as','2021-02-02 19:31:32','2021-02-02 22:12:33'),(29,'resellers_login_as','2021-02-02 19:31:32','2021-02-09 11:49:25');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `schedulers`
--

DROP TABLE IF EXISTS `schedulers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `schedulers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `playlist_id` int(11) DEFAULT NULL,
  `broadcaster_id` int(11) NOT NULL,
  `scheduler_type` varchar(255) NOT NULL,
  `link` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `status` varchar(255) NOT NULL DEFAULT 'off',
  `days` varchar(255) DEFAULT NULL,
  `start_day` date DEFAULT NULL,
  `end_day` date DEFAULT NULL,
  `start_hour` time DEFAULT NULL,
  `end_hour` time DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `playlist_id` (`playlist_id`),
  KEY `broadcaster_id` (`broadcaster_id`),
  CONSTRAINT `schedulers_ibfk_1` FOREIGN KEY (`playlist_id`) REFERENCES `playlists` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `schedulers_ibfk_2` FOREIGN KEY (`broadcaster_id`) REFERENCES `broadcasters` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `schedulers`
--

LOCK TABLES `schedulers` WRITE;
/*!40000 ALTER TABLE `schedulers` DISABLE KEYS */;
/*!40000 ALTER TABLE `schedulers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `smtp_configs`
--

DROP TABLE IF EXISTS `smtp_configs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `smtp_configs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `server` varchar(255) NOT NULL,
  `port` varchar(255) NOT NULL,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `ssl` varchar(255) NOT NULL DEFAULT '1',
  `tls` varchar(255) NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `smtp_configs_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `smtp_configs`
--

LOCK TABLES `smtp_configs` WRITE;
/*!40000 ALTER TABLE `smtp_configs` DISABLE KEYS */;
INSERT INTO `smtp_configs` VALUES (1,1,'SMTP_HOST','587','SMTP_USER','SMTP_PASSWORD','SMTP_ADDRESS','0','1','2020-10-16 19:04:03','2020-09-10 08:37:04');
/*!40000 ALTER TABLE `smtp_configs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_schedulers`
--

DROP TABLE IF EXISTS `social_schedulers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `social_schedulers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `broadcaster_id` int(11) NOT NULL,
  `scheduler_type` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL DEFAULT 'off',
  `days` varchar(255) DEFAULT NULL,
  `start_day` date DEFAULT NULL,
  `end_day` date DEFAULT NULL,
  `start_hour` time DEFAULT NULL,
  `end_hour` time DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `playlist_id` (`type`),
  KEY `broadcaster_id` (`broadcaster_id`),
  CONSTRAINT `socialsch1` FOREIGN KEY (`broadcaster_id`) REFERENCES `broadcasters` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_schedulers`
--

LOCK TABLES `social_schedulers` WRITE;
/*!40000 ALTER TABLE `social_schedulers` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_schedulers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_streams`
--

DROP TABLE IF EXISTS `social_streams`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `social_streams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `broadcaster_id` int(11) NOT NULL,
  `youtube_key` varchar(255) DEFAULT NULL,
  `youtube_status` varchar(255) DEFAULT NULL,
  `facebook_key` varchar(255) DEFAULT NULL,
  `facebook_status` varchar(255) DEFAULT NULL,
  `twitch_key` varchar(255) DEFAULT NULL,
  `twitch_status` varchar(255) DEFAULT NULL,
  `twitch_server` varchar(255) DEFAULT NULL,
  `periscope_key` varchar(255) DEFAULT NULL,
  `periscope_status` varchar(255) DEFAULT NULL,
  `dailymotion_key` varchar(255) DEFAULT NULL,
  `dailymotion_status` varchar(255) DEFAULT NULL,
  `custom_key` varchar(255) DEFAULT NULL,
  `custom_status` varchar(255) DEFAULT NULL,
  `custom_url` varchar(255) DEFAULT NULL,
  `stream_type` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `broadforignk` (`broadcaster_id`),
  CONSTRAINT `broadforignk` FOREIGN KEY (`broadcaster_id`) REFERENCES `broadcasters` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_streams`
--

LOCK TABLES `social_streams` WRITE;
/*!40000 ALTER TABLE `social_streams` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_streams` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `supervisor_roles`
--

DROP TABLE IF EXISTS `supervisor_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `supervisor_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supervisor_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `supervisor_id` (`supervisor_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `rolekey` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `supervisorkey` FOREIGN KEY (`supervisor_id`) REFERENCES `supervisors` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `supervisor_roles`
--

LOCK TABLES `supervisor_roles` WRITE;
/*!40000 ALTER TABLE `supervisor_roles` DISABLE KEYS */;
/*!40000 ALTER TABLE `supervisor_roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `supervisors`
--

DROP TABLE IF EXISTS `supervisors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `supervisors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `supervisors`
--

LOCK TABLES `supervisors` WRITE;
/*!40000 ALTER TABLE `supervisors` DISABLE KEYS */;
/*!40000 ALTER TABLE `supervisors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `broadcaster_id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `broadcaster_id` (`broadcaster_id`),
  CONSTRAINT `tag_key` FOREIGN KEY (`broadcaster_id`) REFERENCES `broadcasters` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `templates`
--

DROP TABLE IF EXISTS `templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` longtext NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `templates`
--

LOCK TABLES `templates` WRITE;
/*!40000 ALTER TABLE `templates` DISABLE KEYS */;
INSERT INTO `templates` VALUES (1,'Streaming Account Created','Streaming Account Created','<div id=\"m_-9123406524106093995iccok\" style=\"box-sizing: border-box; background-color: #fafafa;\"><table id=\"m_-9123406524106093995ihlib\" width=\"100%\" height=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; padding: 0; Margin: 0; width: 100%; height: 100%; background-repeat: repeat; background-position: center top; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ilrlz\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995irmra\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i0ogv\" valign=\"top\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0;\"><table id=\"m_-9123406524106093995i9fd2\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"transparent\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; width: 100%; background-color: transparent; background-repeat: repeat; background-position: center top; border-collapse: collapse; table-layout: fixed;\"><tbody id=\"m_-9123406524106093995iu8we\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i0eft\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995isens\" height=\"60\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; height: 60px; padding: 0; Margin: 0;\"><table id=\"m_-9123406524106093995ighgz\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"#3d5ca3\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; background-color: #3d5ca3; width: 600px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995i3f56\" bgcolor=\"rgba(0,0,0,0)\" align=\"left\" style=\"box-sizing: border-box; height: 100px; text-align: left; border-collapse: separate; background-color: rgba(0,0,0,0);\"><tr id=\"m_-9123406524106093995isj69\" style=\"box-sizing: border-box; border-collapse: collapse; min-height: 100px;\"><td id=\"m_-9123406524106093995ikrcu\" bgcolor=\"#3d5ca3\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; Margin: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; background-color: #3d5ca3; max-width: 100px; height: auto; text-align: center;\"><table id=\"m_-9123406524106093995ifggs\" cellspacing=\"0\" cellpadding=\"0\" align=\"left\" style=\"box-sizing: border-box; border-spacing: 0px; float: left; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995itafw\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ikcuq\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i1gb7\" width=\"270\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; width: 270px;\"><table role=\"presentation\" id=\"m_-9123406524106093995imiq3\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995il4x2\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995iivri\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                                      </tr></tbody></table></td></tr></tbody></table><img id=\"m_-9123406524106093995iinzhy\" src=\"https://ci5.googleusercontent.com/proxy/9ihYGWxvFId45DiClu-Kx9ntCECNBQKOM4LqotXiQ9J1ihVd3Fa8Ru6uO1yt5PLBbKKpCz5lihsN5mK38aaI2SHj5tE9ZA=s0-d-e1-ft#http://vdo.hossam.info/uploads/logos/1601892297.png\" width=\"190\" height=\"66\" class=\"CToWUd\" style=\"box-sizing: border-box; border-top-width: 0px; border-right-width: 0px; border-bottom-width: 0px; border-left-width: 0px; border-top-style: initial; border-right-style: initial; border-bottom-style: initial; border-left-style: initial; border-top-color: initial; border-right-color: initial; border-bottom-color: initial; border-left-color: initial; line-height: 100%; outline-color: initial; outline-style: none; outline-width: initial; text-decoration-line: none; text-decoration-style: initial; text-decoration-color: initial; color: black; width: 190px; height: 66px; text-align: right;\"><table id=\"m_-9123406524106093995id7lu\" cellspacing=\"0\" cellpadding=\"0\" align=\"right\" style=\"box-sizing: border-box; border-spacing: 0px; float: right; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ihfjl\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ixoyq\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995iau8b\" width=\"270\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; width: 270px;\"><table id=\"m_-9123406524106093995i82ua\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995i8jym\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995iix6r\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i9mr7\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; display: none;\">\n                                        </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table><table id=\"m_-9123406524106093995ip144\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; width: 100%; border-collapse: collapse; table-layout: fixed;\"><tbody id=\"m_-9123406524106093995iuqxk\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i6wn7\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995isxkh\" bgcolor=\"#fafafa\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; background-color: #fafafa;\"><table id=\"m_-9123406524106093995i2t9x\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"#ffffff\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; background-color: #ffffff; width: 600px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ibxyv\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i254l\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i61da\" bgcolor=\"transparent\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; padding-left: 20px; padding-right: 20px; padding-top: 40px; background-color: transparent;\"><div id=\"iv29p\" style=\"box-sizing: border-box; padding: 10px; text-align: left;\"><span id=\"ix4ws\" style=\"box-sizing: border-box;\"></span><table id=\"iddkp\" width=\"100%\" align=\"center\" class=\"cke_show_border\" style=\"box-sizing: border-box; letter-spacing: normal; orphans: 2; text-transform: none; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; text-decoration-thickness: initial; text-decoration-style: initial; text-decoration-color: initial; text-align: center; font-family: helvetica, \' undefined: helveticaneue\' undefined: ,arial,verdana,sans-serif; font-size: medium; border-spacing: 0px; border: undefined;\"><tbody id=\"i8ia3\" style=\"box-sizing: border-box;\"><tr id=\"izuvy\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"ippne\" width=\"560\" align=\"center\" style=\"box-sizing: border-box; width: 560px;\"><table role=\"presentation\" id=\"iae4b\" width=\"100%\" class=\"cke_show_border\" style=\"box-sizing: border-box; border-spacing: 0px; background-position: left top; padding: 0px; margin: 0px; border: undefined;\"><tbody id=\"izsf7\" style=\"box-sizing: border-box;\"><tr id=\"iql4z\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"itwz4\" align=\"center\" style=\"box-sizing: border-box;\"><h1 id=\"i9kex\" style=\"box-sizing: border-box; margin-right: 0px; margin-bottom: 0px; margin-left: 0px; text-align: justify; padding: 15px 0px; margin: 0px;\"><span id=\"ikyjt\" style=\"box-sizing: border-box; font-size: 20px;\"><span id=\"i1hk3\" style=\"box-sizing: border-box; font-weight: normal;\"><span id=\"ix71k\" style=\"box-sizing: border-box; line-height: 24px;\"><span id=\"i78c6\" style=\"box-sizing: border-box; color: #333333;\"><span id=\"i8ddi\" style=\"box-sizing: border-box; font-family: arial, \' undefined: helveticaneue\';\"> Dear @user_name</span></span></span></span></span><br id=\"ici2g\" style=\"box-sizing: border-box;\"></h1></td></tr><tr id=\"irgzh\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"i3isq\" align=\"left\" style=\"box-sizing: border-box;\"><p id=\"iab5g\" style=\"box-sizing: border-box; margin-right: 0px; margin-bottom: 0px; margin-left: 0px; padding: 0px 35px 0px 40px; margin: 0px;\"><span id=\"i1tss\" style=\"box-sizing: border-box; text-size-adjust: none;\"><span id=\"i9t5t\" style=\"box-sizing: border-box; line-height: 24px;\"><font id=\"ip14b\" face=\"Nunito Sans, sans-serif\" style=\"box-sizing: border-box;\"><span id=\"irxb5\" style=\"box-sizing: border-box; font-size: 14px;\">Your streaming account has been created on the server : @user_domain You can log in with the following credentials :<br id=\"i4zj8\" draggable=\"true\" data-highlightable=\"1\" style=\"box-sizing: border-box;\">URL : @user_domain/broadcaster<br id=\"i4a7n\" draggable=\"true\" data-highlightable=\"1\" style=\"box-sizing: border-box;\">User : </span></font><span id=\"itcl4\" style=\"box-sizing: border-box; font-size: 14px;\"><span id=\"iwez5\" style=\"box-sizing: border-box; font-family: \' undefined: NunitoSans\';\">@user_name</span></span><br id=\"i1k4x\" style=\"box-sizing: border-box;\"><font id=\"iacb4\" face=\"Nunito Sans, sans-serif\" style=\"box-sizing: border-box;\"><span id=\"ibp7d\" style=\"box-sizing: border-box; font-size: 14px;\">Password : @user_blade_password<br id=\"i4c9j\" style=\"box-sizing: border-box;\">Hope you will enjoy the fly with us!!</span></font></span></span></p></td></tr></tbody></table></td></tr></tbody></table></div><table id=\"m_-9123406524106093995i58tt\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995i78s7\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ieq4s\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995iilnh\" width=\"560\" valign=\"top\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; width: 560px;\"><table role=\"presentation\" id=\"m_-9123406524106093995ir4qc\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; background-position: left top; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ikz9r\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995in1e2\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                                      </tr><tr id=\"m_-9123406524106093995iz5sl\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                                      </tr><tr id=\"m_-9123406524106093995iayqj\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i8h1c\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; padding-left: 40px; padding-right: 40px;\">\n                                        </td></tr><tr id=\"m_-9123406524106093995isiwj\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995ijmk1\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; padding-right: 35px; padding-left: 40px;\">\n                                        </td></tr><tr id=\"m_-9123406524106093995irpgg\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                                      </tr><tr id=\"m_-9123406524106093995iwfuz\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i9c2b\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; Margin: 0; padding-left: 10px; padding-right: 10px; padding-top: 40px; padding-bottom: 40px;\"><table id=\"m_-9123406524106093995icbql\" width=\"100%\" style=\"box-sizing: border-box; width: 100%; margin-top: 10px; margin-bottom: 10px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ieega\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ird2s\" style=\"box-sizing: border-box;\"><td id=\"m_-9123406524106093995ix9sw\" height=\"1\" bgcolor=\"rgba(0,0,0,0.1)\" style=\"box-sizing: border-box; border-collapse: collapse; background-color: rgba(0,0,0,0.1); height: 1px;\">\n                                                </td></tr></tbody></table><blockquote id=\"m_-9123406524106093995ifqyl\" style=\"font-style: italic; box-sizing: border-box;\"><span id=\"m_-9123406524106093995ik0ha\" style=\"box-sizing: border-box; font-family: Georgia,serif;\"><span id=\"m_-9123406524106093995ixu03\" data-gjs-type=\"text\" draggable=\"true\" data-highlightable=\"1\" style=\"box-sizing: border-box;\">​​​​​​​</span>support&nbsp; team&nbsp;</span></blockquote></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table><table id=\"m_-9123406524106093995i0swp\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"transparent\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; width: 100%; background-color: transparent; background-repeat: repeat; background-position: center top; border-collapse: collapse; table-layout: fixed;\"><tbody id=\"m_-9123406524106093995iag5ki\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i1fvu\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995ism9p\" bgcolor=\"#fafafa\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; background-color: #fafafa;\"><table id=\"m_-9123406524106093995i131i\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"transparent\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; background-color: transparent; width: 600px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995iqahhi\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i9opr\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                      </tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div>','2021-08-22 21:58:33','2021-11-06 10:32:01'),(2,'Bandwidth Limit Exceeded','Bandwidth Limit Exceeded','<div id=\"m_-9123406524106093995iccok\" style=\"box-sizing: border-box; background-color: #fafafa;\"><table id=\"m_-9123406524106093995ihlib\" width=\"100%\" height=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; padding: 0; Margin: 0; width: 100%; height: 100%; background-repeat: repeat; background-position: center top; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ilrlz\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995irmra\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i0ogv\" valign=\"top\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0;\"><table id=\"m_-9123406524106093995i9fd2\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"transparent\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; width: 100%; background-color: transparent; background-repeat: repeat; background-position: center top; border-collapse: collapse; table-layout: fixed;\"><tbody id=\"m_-9123406524106093995iu8we\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i0eft\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995isens\" height=\"60\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; height: 60px; padding: 0; Margin: 0;\"><table id=\"m_-9123406524106093995ighgz\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"#3d5ca3\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; background-color: #3d5ca3; width: 600px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995i3f56\" bgcolor=\"rgba(0,0,0,0)\" align=\"left\" style=\"box-sizing: border-box; height: 100px; text-align: left; border-collapse: separate; background-color: rgba(0,0,0,0);\"><tr id=\"m_-9123406524106093995isj69\" style=\"box-sizing: border-box; border-collapse: collapse; min-height: 100px;\"><td id=\"m_-9123406524106093995ikrcu\" bgcolor=\"#3d5ca3\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; Margin: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; background-color: #3d5ca3; max-width: 100px; height: auto; text-align: center;\"><table id=\"m_-9123406524106093995ifggs\" cellspacing=\"0\" cellpadding=\"0\" align=\"left\" style=\"box-sizing: border-box; border-spacing: 0px; float: left; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995itafw\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ikcuq\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i1gb7\" width=\"270\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; width: 270px;\"><table role=\"presentation\" id=\"m_-9123406524106093995imiq3\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995il4x2\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995iivri\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                                      </tr></tbody></table></td></tr></tbody></table><img id=\"m_-9123406524106093995iinzhy\" src=\"https://ci5.googleusercontent.com/proxy/9ihYGWxvFId45DiClu-Kx9ntCECNBQKOM4LqotXiQ9J1ihVd3Fa8Ru6uO1yt5PLBbKKpCz5lihsN5mK38aaI2SHj5tE9ZA=s0-d-e1-ft#http://vdo.hossam.info/uploads/logos/1601892297.png\" width=\"190\" height=\"66\" class=\"CToWUd\" style=\"box-sizing: border-box; border-top-width: 0px; border-right-width: 0px; border-bottom-width: 0px; border-left-width: 0px; border-top-style: initial; border-right-style: initial; border-bottom-style: initial; border-left-style: initial; border-top-color: initial; border-right-color: initial; border-bottom-color: initial; border-left-color: initial; line-height: 100%; outline-color: initial; outline-style: none; outline-width: initial; text-decoration-line: none; text-decoration-style: initial; text-decoration-color: initial; color: black; width: 190px; height: 66px; text-align: right;\"><table id=\"m_-9123406524106093995id7lu\" cellspacing=\"0\" cellpadding=\"0\" align=\"right\" style=\"box-sizing: border-box; border-spacing: 0px; float: right; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ihfjl\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ixoyq\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995iau8b\" width=\"270\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; width: 270px;\"><table id=\"m_-9123406524106093995i82ua\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995i8jym\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995iix6r\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i9mr7\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; display: none;\">\n                                        </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table><table id=\"m_-9123406524106093995ip144\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; width: 100%; border-collapse: collapse; table-layout: fixed;\"><tbody id=\"m_-9123406524106093995iuqxk\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i6wn7\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995isxkh\" bgcolor=\"#fafafa\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; background-color: #fafafa;\"><table id=\"m_-9123406524106093995i2t9x\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"#ffffff\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; background-color: #ffffff; width: 600px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ibxyv\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i254l\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i61da\" bgcolor=\"transparent\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; padding-left: 20px; padding-right: 20px; padding-top: 40px; background-color: transparent;\"><div id=\"iv29p\" style=\"box-sizing: border-box; padding: 10px; text-align: left;\"> Dear @user_name ,<br id=\"iv4c6\" draggable=\"true\" data-highlightable=\"1\" style=\"box-sizing: border-box;\">​​​​​​​Your live transmission is more than @user_band % of your bandwidth package on @user_name account , On 100% usage your transmission will stop , but if this happens too often, you might be banned from this site<br id=\"ixyyt\" draggable=\"true\" data-highlightable=\"1\" style=\"box-sizing: border-box;\"><br id=\"ijiex\" draggable=\"true\" data-highlightable=\"1\" style=\"box-sizing: border-box;\">Please, consider upgrading your bandwidth limit by contacting admin.@user_company_name Team</div><table id=\"m_-9123406524106093995i58tt\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995i78s7\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ieq4s\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995iilnh\" width=\"560\" valign=\"top\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; width: 560px;\"><table role=\"presentation\" id=\"m_-9123406524106093995ir4qc\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; background-position: left top; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ikz9r\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995in1e2\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                                      </tr><tr id=\"m_-9123406524106093995iz5sl\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                                      </tr><tr id=\"m_-9123406524106093995iayqj\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i8h1c\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; padding-left: 40px; padding-right: 40px;\">\n                                        </td></tr><tr id=\"m_-9123406524106093995isiwj\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995ijmk1\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; padding-right: 35px; padding-left: 40px;\">\n                                        </td></tr><tr id=\"m_-9123406524106093995irpgg\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                                      </tr><tr id=\"m_-9123406524106093995iwfuz\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i9c2b\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; Margin: 0; padding-left: 10px; padding-right: 10px; padding-top: 40px; padding-bottom: 40px;\"><table id=\"m_-9123406524106093995icbql\" width=\"100%\" style=\"box-sizing: border-box; width: 100%; margin-top: 10px; margin-bottom: 10px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ieega\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ird2s\" style=\"box-sizing: border-box;\"><td id=\"m_-9123406524106093995ix9sw\" height=\"1\" bgcolor=\"rgba(0,0,0,0.1)\" style=\"box-sizing: border-box; border-collapse: collapse; background-color: rgba(0,0,0,0.1); height: 1px;\">\n                                                </td></tr></tbody></table><blockquote id=\"m_-9123406524106093995ifqyl\" style=\"font-style: italic; box-sizing: border-box;\"><span id=\"m_-9123406524106093995ik0ha\" style=\"box-sizing: border-box; font-family: Georgia,serif;\"><span id=\"m_-9123406524106093995ixu03\" data-gjs-type=\"text\" draggable=\"true\" data-highlightable=\"1\" style=\"box-sizing: border-box;\">​​​​​​​</span>support&nbsp; team&nbsp;</span></blockquote></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table><table id=\"m_-9123406524106093995i0swp\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"transparent\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; width: 100%; background-color: transparent; background-repeat: repeat; background-position: center top; border-collapse: collapse; table-layout: fixed;\"><tbody id=\"m_-9123406524106093995iag5ki\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i1fvu\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995ism9p\" bgcolor=\"#fafafa\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; background-color: #fafafa;\"><table id=\"m_-9123406524106093995i131i\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"transparent\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; background-color: transparent; width: 600px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995iqahhi\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i9opr\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                      </tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div>','2021-08-09 10:53:28','2021-11-06 10:30:05'),(3,'Service Suspended','Service Suspended','<div id=\"m_-9123406524106093995iccok\" style=\"box-sizing: border-box; background-color: #fafafa;\"><table id=\"m_-9123406524106093995ihlib\" width=\"100%\" height=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; padding: 0; Margin: 0; width: 100%; height: 100%; background-repeat: repeat; background-position: center top; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ilrlz\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995irmra\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i0ogv\" valign=\"top\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0;\"><table id=\"m_-9123406524106093995i9fd2\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"transparent\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; width: 100%; background-color: transparent; background-repeat: repeat; background-position: center top; border-collapse: collapse; table-layout: fixed;\"><tbody id=\"m_-9123406524106093995iu8we\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i0eft\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995isens\" height=\"60\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; height: 60px; padding: 0; Margin: 0;\"><table id=\"m_-9123406524106093995ighgz\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"#3d5ca3\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; background-color: #3d5ca3; width: 600px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995i3f56\" bgcolor=\"rgba(0,0,0,0)\" align=\"left\" style=\"box-sizing: border-box; height: 100px; text-align: left; border-collapse: separate; background-color: rgba(0,0,0,0);\"><tr id=\"m_-9123406524106093995isj69\" style=\"box-sizing: border-box; border-collapse: collapse; min-height: 100px;\"><td id=\"m_-9123406524106093995ikrcu\" bgcolor=\"#3d5ca3\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; Margin: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; background-color: #3d5ca3; max-width: 100px; height: auto; text-align: center;\"><table id=\"m_-9123406524106093995ifggs\" cellspacing=\"0\" cellpadding=\"0\" align=\"left\" style=\"box-sizing: border-box; border-spacing: 0px; float: left; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995itafw\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ikcuq\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i1gb7\" width=\"270\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; width: 270px;\"><table role=\"presentation\" id=\"m_-9123406524106093995imiq3\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995il4x2\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995iivri\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                                      </tr></tbody></table></td></tr></tbody></table><img id=\"m_-9123406524106093995iinzhy\" src=\"https://ci5.googleusercontent.com/proxy/9ihYGWxvFId45DiClu-Kx9ntCECNBQKOM4LqotXiQ9J1ihVd3Fa8Ru6uO1yt5PLBbKKpCz5lihsN5mK38aaI2SHj5tE9ZA=s0-d-e1-ft#http://vdo.hossam.info/uploads/logos/1601892297.png\" width=\"190\" height=\"66\" class=\"CToWUd\" style=\"box-sizing: border-box; border-top-width: 0px; border-right-width: 0px; border-bottom-width: 0px; border-left-width: 0px; border-top-style: initial; border-right-style: initial; border-bottom-style: initial; border-left-style: initial; border-top-color: initial; border-right-color: initial; border-bottom-color: initial; border-left-color: initial; line-height: 100%; outline-color: initial; outline-style: none; outline-width: initial; text-decoration-line: none; text-decoration-style: initial; text-decoration-color: initial; color: black; width: 190px; height: 66px; text-align: right;\"><table id=\"m_-9123406524106093995id7lu\" cellspacing=\"0\" cellpadding=\"0\" align=\"right\" style=\"box-sizing: border-box; border-spacing: 0px; float: right; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ihfjl\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ixoyq\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995iau8b\" width=\"270\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; width: 270px;\"><table id=\"m_-9123406524106093995i82ua\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995i8jym\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995iix6r\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i9mr7\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; display: none;\">\n                                        </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table><table id=\"m_-9123406524106093995ip144\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; width: 100%; border-collapse: collapse; table-layout: fixed;\"><tbody id=\"m_-9123406524106093995iuqxk\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i6wn7\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995isxkh\" bgcolor=\"#fafafa\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; background-color: #fafafa;\"><table id=\"m_-9123406524106093995i2t9x\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"#ffffff\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; background-color: #ffffff; width: 600px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ibxyv\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i254l\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i61da\" bgcolor=\"transparent\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; padding-left: 20px; padding-right: 20px; padding-top: 40px; background-color: transparent;\"><div id=\"iv29p\" style=\"box-sizing: border-box; padding: 10px; text-align: left;\"><p id=\"in0i5\" style=\"box-sizing: border-box;\"> Dear @user_name</p><p id=\"im2pj\" style=\"box-sizing: border-box;\">Your account @user_name has been suspended.<br id=\"iu0s9\" draggable=\"true\" data-highlightable=\"1\" style=\"box-sizing: border-box;\">This ban has been decided by admin<br id=\"i83vn\" draggable=\"true\" data-highlightable=\"1\" style=\"box-sizing: border-box;\">Please, contact : @user_admin_email to know the reasons for this</p><p id=\"ik13l\" style=\"box-sizing: border-box;\"><br id=\"imlfw\" draggable=\"true\" data-highlightable=\"1\" style=\"box-sizing: border-box;\">@user_company_name Team</p></div><table id=\"m_-9123406524106093995i58tt\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995i78s7\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ieq4s\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995iilnh\" width=\"560\" valign=\"top\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; width: 560px;\"><table role=\"presentation\" id=\"m_-9123406524106093995ir4qc\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; background-position: left top; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ikz9r\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995in1e2\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                                      </tr><tr id=\"m_-9123406524106093995iz5sl\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                                      </tr><tr id=\"m_-9123406524106093995iayqj\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i8h1c\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; padding-left: 40px; padding-right: 40px;\">\n                                        </td></tr><tr id=\"m_-9123406524106093995isiwj\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995ijmk1\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; padding-right: 35px; padding-left: 40px;\">\n                                        </td></tr><tr id=\"m_-9123406524106093995irpgg\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                                      </tr><tr id=\"m_-9123406524106093995iwfuz\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i9c2b\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; Margin: 0; padding-left: 10px; padding-right: 10px; padding-top: 40px; padding-bottom: 40px;\"><table id=\"m_-9123406524106093995icbql\" width=\"100%\" style=\"box-sizing: border-box; width: 100%; margin-top: 10px; margin-bottom: 10px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ieega\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ird2s\" style=\"box-sizing: border-box;\"><td id=\"m_-9123406524106093995ix9sw\" height=\"1\" bgcolor=\"rgba(0,0,0,0.1)\" style=\"box-sizing: border-box; border-collapse: collapse; background-color: rgba(0,0,0,0.1); height: 1px;\">\n                                                </td></tr></tbody></table><blockquote id=\"m_-9123406524106093995ifqyl\" style=\"font-style: italic; box-sizing: border-box;\"><span id=\"m_-9123406524106093995ik0ha\" style=\"box-sizing: border-box; font-family: Georgia,serif;\"><span id=\"m_-9123406524106093995ixu03\" data-gjs-type=\"text\" draggable=\"true\" data-highlightable=\"1\" style=\"box-sizing: border-box;\">​​​​​​​</span>support&nbsp; team <br style=\"box-sizing: border-box;\"></span></blockquote></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table><table id=\"m_-9123406524106093995i0swp\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"transparent\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; width: 100%; background-color: transparent; background-repeat: repeat; background-position: center top; border-collapse: collapse; table-layout: fixed;\"><tbody id=\"m_-9123406524106093995iag5ki\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i1fvu\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995ism9p\" bgcolor=\"#fafafa\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; background-color: #fafafa;\"><table id=\"m_-9123406524106093995i131i\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"transparent\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; background-color: transparent; width: 600px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995iqahhi\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i9opr\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                      </tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div>','2021-08-08 17:57:13','2021-11-06 10:30:50'),(4,'Disk Quota Limit Exceeded','Disk Quota Limit Exceeded','<div id=\"m_-9123406524106093995iccok\" style=\"box-sizing: border-box; background-color: #fafafa;\"><table id=\"m_-9123406524106093995ihlib\" width=\"100%\" height=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; padding: 0; Margin: 0; width: 100%; height: 100%; background-repeat: repeat; background-position: center top; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ilrlz\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995irmra\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i0ogv\" valign=\"top\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0;\"><table id=\"m_-9123406524106093995i9fd2\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"transparent\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; width: 100%; background-color: transparent; background-repeat: repeat; background-position: center top; border-collapse: collapse; table-layout: fixed;\"><tbody id=\"m_-9123406524106093995iu8we\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i0eft\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995isens\" height=\"60\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; height: 60px; padding: 0; Margin: 0;\"><table id=\"m_-9123406524106093995ighgz\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"#3d5ca3\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; background-color: #3d5ca3; width: 600px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995i3f56\" bgcolor=\"rgba(0,0,0,0)\" align=\"left\" style=\"box-sizing: border-box; height: 100px; text-align: left; border-collapse: separate; background-color: rgba(0,0,0,0);\"><tr id=\"m_-9123406524106093995isj69\" style=\"box-sizing: border-box; border-collapse: collapse; min-height: 100px;\"><td id=\"m_-9123406524106093995ikrcu\" bgcolor=\"#3d5ca3\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; Margin: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; background-color: #3d5ca3; max-width: 100px; height: auto; text-align: center;\"><table id=\"m_-9123406524106093995ifggs\" cellspacing=\"0\" cellpadding=\"0\" align=\"left\" style=\"box-sizing: border-box; border-spacing: 0px; float: left; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995itafw\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ikcuq\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i1gb7\" width=\"270\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; width: 270px;\"><table role=\"presentation\" id=\"m_-9123406524106093995imiq3\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995il4x2\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995iivri\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                                      </tr></tbody></table></td></tr></tbody></table><img id=\"m_-9123406524106093995iinzhy\" src=\"https://ci5.googleusercontent.com/proxy/9ihYGWxvFId45DiClu-Kx9ntCECNBQKOM4LqotXiQ9J1ihVd3Fa8Ru6uO1yt5PLBbKKpCz5lihsN5mK38aaI2SHj5tE9ZA=s0-d-e1-ft#http://vdo.hossam.info/uploads/logos/1601892297.png\" width=\"190\" height=\"66\" class=\"CToWUd\" style=\"box-sizing: border-box; border-top-width: 0px; border-right-width: 0px; border-bottom-width: 0px; border-left-width: 0px; border-top-style: initial; border-right-style: initial; border-bottom-style: initial; border-left-style: initial; border-top-color: initial; border-right-color: initial; border-bottom-color: initial; border-left-color: initial; line-height: 100%; outline-color: initial; outline-style: none; outline-width: initial; text-decoration-line: none; text-decoration-style: initial; text-decoration-color: initial; color: black; width: 190px; height: 66px; text-align: right;\"><table id=\"m_-9123406524106093995id7lu\" cellspacing=\"0\" cellpadding=\"0\" align=\"right\" style=\"box-sizing: border-box; border-spacing: 0px; float: right; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ihfjl\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ixoyq\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995iau8b\" width=\"270\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; width: 270px;\"><table id=\"m_-9123406524106093995i82ua\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995i8jym\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995iix6r\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i9mr7\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; display: none;\">\n                                        </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table><table id=\"m_-9123406524106093995ip144\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; width: 100%; border-collapse: collapse; table-layout: fixed;\"><tbody id=\"m_-9123406524106093995iuqxk\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i6wn7\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995isxkh\" bgcolor=\"#fafafa\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; background-color: #fafafa;\"><table id=\"m_-9123406524106093995i2t9x\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"#ffffff\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; background-color: #ffffff; width: 600px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ibxyv\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i254l\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i61da\" bgcolor=\"transparent\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; padding-left: 20px; padding-right: 20px; padding-top: 40px; background-color: transparent;\"><div id=\"iv29p\" style=\"box-sizing: border-box; padding: 10px; text-align: left;\"><span id=\"ixsrr\" style=\"box-sizing: border-box; background-color: transparent;\">Dear @user_name</span><p id=\"izulf\" style=\"box-sizing: border-box;\">Your live transmission is more than @user_storage % of your disk quota limit on  @user_name  account , On 100% usage your transmission will stop , but if this happens too often, you might be banned from this site Please, consider upgrading your disk quota limit by contacting admin.<br id=\"iuymr\" draggable=\"true\" data-highlightable=\"1\" style=\"box-sizing: border-box;\">​​​​​​​<br id=\"ievqj\" draggable=\"true\" data-highlightable=\"1\" style=\"box-sizing: border-box;\">@user_company_name Team</p></div><table id=\"m_-9123406524106093995i58tt\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995i78s7\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ieq4s\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995iilnh\" width=\"560\" valign=\"top\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; width: 560px;\"><table role=\"presentation\" id=\"m_-9123406524106093995ir4qc\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; background-position: left top; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ikz9r\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995in1e2\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                                      </tr><tr id=\"m_-9123406524106093995iz5sl\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                                      </tr><tr id=\"m_-9123406524106093995iayqj\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i8h1c\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; padding-left: 40px; padding-right: 40px;\">\n                                        </td></tr><tr id=\"m_-9123406524106093995isiwj\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995ijmk1\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; padding-right: 35px; padding-left: 40px;\">\n                                        </td></tr><tr id=\"m_-9123406524106093995irpgg\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                                      </tr><tr id=\"m_-9123406524106093995iwfuz\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i9c2b\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; Margin: 0; padding-left: 10px; padding-right: 10px; padding-top: 40px; padding-bottom: 40px;\"><table id=\"m_-9123406524106093995icbql\" width=\"100%\" style=\"box-sizing: border-box; width: 100%; margin-top: 10px; margin-bottom: 10px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ieega\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ird2s\" style=\"box-sizing: border-box;\"><td id=\"m_-9123406524106093995ix9sw\" height=\"1\" bgcolor=\"rgba(0,0,0,0.1)\" style=\"box-sizing: border-box; border-collapse: collapse; background-color: rgba(0,0,0,0.1); height: 1px;\">\n                                                </td></tr></tbody></table><blockquote id=\"m_-9123406524106093995ifqyl\" style=\"font-style: italic; box-sizing: border-box;\"><span id=\"m_-9123406524106093995ik0ha\" style=\"box-sizing: border-box; font-family: Georgia,serif;\"><span id=\"m_-9123406524106093995ixu03\" data-gjs-type=\"text\" draggable=\"true\" data-highlightable=\"1\" style=\"box-sizing: border-box;\">​​​​​​​</span>support&nbsp; team&nbsp;</span></blockquote></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table><table id=\"m_-9123406524106093995i0swp\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"transparent\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; width: 100%; background-color: transparent; background-repeat: repeat; background-position: center top; border-collapse: collapse; table-layout: fixed;\"><tbody id=\"m_-9123406524106093995iag5ki\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i1fvu\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995ism9p\" bgcolor=\"#fafafa\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; background-color: #fafafa;\"><table id=\"m_-9123406524106093995i131i\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"transparent\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; background-color: transparent; width: 600px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995iqahhi\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i9opr\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                      </tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div>','2021-08-08 18:30:26','2021-11-06 10:30:31'),(5,'Reset password','Reset your password','<meta charset=\"UTF-8\"><meta content=\"width=device-width, initial-scale=1\" name=\"viewport\"><meta name=\"x-apple-disable-message-reformatting\"><meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\"><meta content=\"telephone=no\" name=\"format-detection\"><title>New email template 2020-08-08</title><div id=\"iccok\" class=\"es-wrapper-color\" style=\"box-sizing: border-box; background-color: #FAFAFA;\"><table id=\"ihlib\" width=\"100%\" height=\"100%\" cellspacing=\"0\" cellpadding=\"0\" class=\"es-wrapper\" style=\"box-sizing: border-box; text-size-adjust: 100%; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-spacing: 0px; padding: 0; Margin: 0; width: 100%; height: 100%; background-repeat: repeat; background-position: center top; border-collapse: collapse;\"><tbody id=\"i2b5z\" style=\"box-sizing: border-box;\"><tr id=\"irmra\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"i0ogv\" valign=\"top\" style=\"box-sizing: border-box; border-collapse: collapse; text-size-adjust: 100%; padding: 0; Margin: 0;\"><table id=\"i9fd2\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"transparent\" align=\"center\" class=\"es-header\" style=\"box-sizing: border-box; text-size-adjust: 100%; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-spacing: 0px; width: 100%; background-color: transparent; background-repeat: repeat; background-position: center top; border-collapse: collapse; table-layout: fixed;\"><tbody id=\"ik0j4\" style=\"box-sizing: border-box;\"><tr id=\"i0eft\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"isens\" height=\"60\" align=\"center\" class=\"es-adaptive\" style=\"box-sizing: border-box; border-collapse: collapse; text-size-adjust: 100%; height: 60px; padding: 0; Margin: 0;\"><table id=\"ighgz\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"#3d5ca3\" align=\"center\" class=\"es-header-body\" style=\"box-sizing: border-box; text-size-adjust: 100%; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-spacing: 0px; background-color: #3d5ca3; width: 600px; border-collapse: collapse;\"><tbody id=\"i3f56\" bgcolor=\"rgba(0,0,0,0)\" align=\"left\" style=\"box-sizing: border-box; height: 100px; text-align: left; border-collapse: separate; background-color: rgba(0,0,0,0);\"><tr id=\"isj69\" style=\"box-sizing: border-box; border-collapse: collapse; min-height: 100px;\"><td id=\"ikrcu\" bgcolor=\"#3d5ca3\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; text-size-adjust: 100%; Margin: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; background-color: #3d5ca3; max-width: 100px; height: auto; text-align: center;\"><table id=\"ifggs\" cellspacing=\"0\" cellpadding=\"0\" align=\"left\" class=\"es-left\" style=\"box-sizing: border-box; text-size-adjust: 100%; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-spacing: 0px; float: left; border-collapse: collapse;\"><tbody id=\"io3px\" style=\"box-sizing: border-box;\"><tr id=\"ikcuq\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"i1gb7\" width=\"270\" align=\"left\" class=\"es-m-p20b\" style=\"box-sizing: border-box; border-collapse: collapse; text-size-adjust: 100%; padding: 0; Margin: 0; width: 270px;\"><table role=\"presentation\" id=\"imiq3\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; text-size-adjust: 100%; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-spacing: 0px; border-collapse: collapse;\"><tbody id=\"i8o3n\" style=\"box-sizing: border-box;\"><tr id=\"iivri\" style=\"box-sizing: border-box; border-collapse: collapse;\"></tr></tbody></table></td></tr></tbody></table><img id=\"iinzhy\" src=\"http://vdo.hossam.info/uploads/logos/1601892297.png\" width=\"190\" height=\"66\" style=\"box-sizing: border-box; border-top-width: 0px; border-right-width: 0px; border-bottom-width: 0px; border-left-width: 0px; border-top-style: initial; border-right-style: initial; border-bottom-style: initial; border-left-style: initial; border-top-color: initial; border-right-color: initial; border-bottom-color: initial; border-left-color: initial; border-image-source: initial; border-image-slice: initial; border-image-width: initial; border-image-outset: initial; border-image-repeat: initial; line-height: 100%; outline-color: initial; outline-style: none; outline-width: initial; text-decoration-line: none; text-decoration-thickness: initial; text-decoration-style: initial; text-decoration-color: initial; color: black; width: 190px; height: 66px; text-align: right;\"><table id=\"id7lu\" cellspacing=\"0\" cellpadding=\"0\" align=\"right\" class=\"es-right\" style=\"box-sizing: border-box; text-size-adjust: 100%; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-spacing: 0px; float: right; border-collapse: collapse;\"><tbody id=\"iolgr\" style=\"box-sizing: border-box;\"><tr id=\"ixoyq\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"iau8b\" width=\"270\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; text-size-adjust: 100%; padding: 0; Margin: 0; width: 270px;\"><table id=\"i82ua\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; text-size-adjust: 100%; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-spacing: 0px; border-collapse: collapse;\"><tbody id=\"ibj1z\" style=\"box-sizing: border-box;\"><tr id=\"iix6r\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"i9mr7\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; text-size-adjust: 100%; padding: 0; Margin: 0; display: none;\"></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table><table id=\"ip144\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" class=\"es-content\" style=\"box-sizing: border-box; text-size-adjust: 100%; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-spacing: 0px; width: 100%; border-collapse: collapse; table-layout: fixed;\"><tbody id=\"itvsi\" style=\"box-sizing: border-box;\"><tr id=\"i6wn7\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"isxkh\" bgcolor=\"#fafafa\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; text-size-adjust: 100%; padding: 0; Margin: 0; background-color: #fafafa;\"><table id=\"i2t9x\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"#ffffff\" align=\"center\" class=\"es-content-body\" style=\"box-sizing: border-box; text-size-adjust: 100%; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-spacing: 0px; background-color: #ffffff; width: 600px; border-collapse: collapse;\"><tbody id=\"ii4vk\" style=\"box-sizing: border-box;\"><tr id=\"i254l\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"i61da\" bgcolor=\"transparent\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; text-size-adjust: 100%; padding: 0; Margin: 0; padding-left: 20px; padding-right: 20px; padding-top: 40px; background-color: transparent; background-position: left top;\"><table id=\"i58tt\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; text-size-adjust: 100%; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-spacing: 0px; border-collapse: collapse;\"><tbody id=\"ik48z\" style=\"box-sizing: border-box;\"><tr id=\"ieq4s\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"iilnh\" width=\"560\" valign=\"top\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; text-size-adjust: 100%; padding: 0; Margin: 0; width: 560px;\"><table role=\"presentation\" id=\"ir4qc\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; text-size-adjust: 100%; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-spacing: 0px; background-position: left top; border-collapse: collapse;\"><tbody id=\"iq36g\" style=\"box-sizing: border-box;\"><tr id=\"in1e2\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"i4123\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; text-size-adjust: 100%; padding: 0; Margin: 0; padding-top: 5px; padding-bottom: 5px; font-size: 0;\"><img src=\"https://dwnyx.stripocdn.email/content/guids/CABINET_dd354a98a803b60e2f0411e893c82f56/images/23891556799905703.png\" alt=\"\" id=\"ib2x2\" width=\"175\" style=\"box-sizing: border-box; border-top-width: 0px; border-right-width: 0px; border-bottom-width: 0px; border-left-width: 0px; border-top-style: initial; border-right-style: initial; border-bottom-style: initial; border-left-style: initial; border-top-color: initial; border-right-color: initial; border-bottom-color: initial; border-left-color: initial; border-image-source: initial; border-image-slice: initial; border-image-width: initial; border-image-outset: initial; border-image-repeat: initial; height: auto; line-height: 100%; outline-color: initial; outline-style: none; outline-width: initial; text-decoration-line: none; text-decoration-thickness: initial; text-decoration-style: initial; text-decoration-color: initial; display: block; border: 0; outline: none; text-decoration: none; -ms-interpolation-mode: bicubic;\"></td></tr><tr id=\"iz5sl\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"iczjf\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; text-size-adjust: 100%; padding: 0; Margin: 0; padding-top: 15px; padding-bottom: 15px;\"><h1 id=\"ikxkg\" style=\"box-sizing: border-box; Margin: 0; line-height: 24px; mso-line-height-rule: exactly; font-family: arial, \'helvetica neue\', helvetica, sans-serif; font-size: 20px; font-style: normal; font-weight: normal; color: #333333;\"><strong id=\"ix1fb\" style=\"box-sizing: border-box;\">FORGOT YOUR </strong></h1><h1 id=\"ip9ot\" style=\"box-sizing: border-box; Margin: 0; line-height: 24px; mso-line-height-rule: exactly; font-family: arial, \'helvetica neue\', helvetica, sans-serif; font-size: 20px; font-style: normal; font-weight: normal; color: #333333;\"><strong id=\"iagj6\" style=\"box-sizing: border-box;\"> PASSWORD?</strong></h1></td></tr><tr id=\"iayqj\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"i8h1c\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; text-size-adjust: 100%; padding: 0; Margin: 0; padding-left: 40px; padding-right: 40px;\"><p id=\"itdic\" style=\"box-sizing: border-box; display: block; margin-top: 13px; margin-right: 0px; margin-bottom: 13px; margin-left: 0px; Margin: 0; -webkit-text-size-adjust: none; -ms-text-size-adjust: none; mso-line-height-rule: exactly; font-family: helvetica, \'helvetica neue\', arial, verdana, sans-serif; line-height: 24px; color: #666666; font-size: 16px; text-align: center;\">HI, @user_name</p></td></tr><tr id=\"isiwj\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"ijmk1\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; text-size-adjust: 100%; padding: 0; Margin: 0; padding-right: 35px; padding-left: 40px;\"><p id=\"i3cc2\" style=\"box-sizing: border-box; display: block; margin-top: 13px; margin-right: 0px; margin-bottom: 13px; margin-left: 0px; Margin: 0; -webkit-text-size-adjust: none; -ms-text-size-adjust: none; mso-line-height-rule: exactly; font-family: helvetica, \'helvetica neue\', arial, verdana, sans-serif; line-height: 24px; color: #666666; font-size: 16px; text-align: center;\">There was a request to change your password!</p></td></tr><tr id=\"irpgg\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"imi89\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; text-size-adjust: 100%; padding: 0; Margin: 0; padding-top: 25px; padding-left: 40px; padding-right: 40px;\"><p id=\"ieovt\" style=\"box-sizing: border-box; display: block; margin-top: 13px; margin-right: 0px; margin-bottom: 13px; margin-left: 0px; Margin: 0; -webkit-text-size-adjust: none; -ms-text-size-adjust: none; mso-line-height-rule: exactly; font-family: helvetica, \'helvetica neue\', arial, verdana, sans-serif; line-height: 24px; color: #666666; font-size: 16px;\">If did not make this request, just ignore this email. Otherwise, please click the link below to change your password:<br id=\"i12cv\" draggable=\"true\" data-highlightable=\"1\" style=\"box-sizing: border-box;\">@user_resetlink</p></td></tr><tr id=\"iwfuz\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"i9c2b\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; text-size-adjust: 100%; Margin: 0; padding-left: 10px; padding-right: 10px; padding-top: 40px; padding-bottom: 40px;\"><table id=\"icbql\" width=\"100%\" style=\"box-sizing: border-box; text-size-adjust: 100%; width: 100%; margin-top: 10px; margin-bottom: 10px; border-collapse: collapse;\"><tbody id=\"idaof\" style=\"box-sizing: border-box;\"><tr id=\"ivopo\" style=\"box-sizing: border-box;\"><td id=\"ih4wg\" height=\"1\" bgcolor=\"rgba(0, 0, 0, 0.1)\" class=\"divider\" style=\"box-sizing: border-box; border-collapse: collapse; text-size-adjust: 100%; background-color: rgba(0, 0, 0, 0.1); height: 1px;\"></td></tr></tbody></table><blockquote id=\"iowjh\" class=\"quote\" style=\"font-style: italic; box-sizing: border-box;\"><span id=\"ie40o\" style=\"box-sizing: border-box; font-family: Georgia,serif;\"><span id=\"ih3js\" data-gjs-type=\"text\" draggable=\"true\" data-highlightable=\"1\" style=\"box-sizing: border-box;\">​​​​​​​</span>support&nbsp; team&nbsp;</span></blockquote></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table><table id=\"i0swp\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"transparent\" align=\"center\" class=\"es-footer\" style=\"box-sizing: border-box; text-size-adjust: 100%; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-spacing: 0px; width: 100%; background-color: transparent; background-repeat: repeat; background-position: center top; border-collapse: collapse; table-layout: fixed;\"><tbody id=\"i1cll\" style=\"box-sizing: border-box;\"><tr id=\"i1fvu\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"ism9p\" bgcolor=\"#fafafa\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; text-size-adjust: 100%; padding: 0; Margin: 0; background-color: #fafafa;\"><table id=\"i131i\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"transparent\" align=\"center\" class=\"es-footer-body\" style=\"box-sizing: border-box; text-size-adjust: 100%; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-spacing: 0px; background-color: transparent; width: 600px; border-collapse: collapse;\"><tbody id=\"ixtwkq\" style=\"box-sizing: border-box;\"><tr id=\"i9opr\" style=\"box-sizing: border-box; border-collapse: collapse;\"></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div>','2021-08-26 08:41:49','2021-11-06 10:31:08'),(6,'Test Message','Test Message','<div id=\"m_-9123406524106093995iccok\" style=\"box-sizing: border-box; background-color: #fafafa;\"><table id=\"m_-9123406524106093995ihlib\" width=\"100%\" height=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; padding: 0; Margin: 0; width: 100%; height: 100%; background-repeat: repeat; background-position: center top; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ilrlz\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995irmra\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i0ogv\" valign=\"top\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0;\"><table id=\"m_-9123406524106093995i9fd2\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"transparent\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; width: 100%; background-color: transparent; background-repeat: repeat; background-position: center top; border-collapse: collapse; table-layout: fixed;\"><tbody id=\"m_-9123406524106093995iu8we\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i0eft\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995isens\" height=\"60\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; height: 60px; padding: 0; Margin: 0;\"><table id=\"m_-9123406524106093995ighgz\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"#3d5ca3\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; background-color: #3d5ca3; width: 600px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995i3f56\" bgcolor=\"rgba(0,0,0,0)\" align=\"left\" style=\"box-sizing: border-box; height: 100px; text-align: left; border-collapse: separate; background-color: rgba(0,0,0,0);\"><tr id=\"m_-9123406524106093995isj69\" style=\"box-sizing: border-box; border-collapse: collapse; min-height: 100px;\"><td id=\"m_-9123406524106093995ikrcu\" bgcolor=\"#3d5ca3\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; Margin: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; background-color: #3d5ca3; max-width: 100px; height: auto; text-align: center;\"><img id=\"m_-9123406524106093995iinzhy\" src=\"https://ci5.googleusercontent.com/proxy/9ihYGWxvFId45DiClu-Kx9ntCECNBQKOM4LqotXiQ9J1ihVd3Fa8Ru6uO1yt5PLBbKKpCz5lihsN5mK38aaI2SHj5tE9ZA=s0-d-e1-ft#http://vdo.hossam.info/uploads/logos/1601892297.png\" width=\"190\" height=\"66\" class=\"CToWUd\" style=\"box-sizing: border-box; border-top-width: 0px; border-right-width: 0px; border-bottom-width: 0px; border-left-width: 0px; border-top-style: initial; border-right-style: initial; border-bottom-style: initial; border-left-style: initial; border-top-color: initial; border-right-color: initial; border-bottom-color: initial; border-left-color: initial; line-height: 100%; outline-color: initial; outline-style: none; outline-width: initial; text-decoration-line: none; text-decoration-style: initial; text-decoration-color: initial; color: black; width: 190px; height: 66px; text-align: right;\"><table id=\"m_-9123406524106093995ifggs\" cellspacing=\"0\" cellpadding=\"0\" align=\"left\" style=\"box-sizing: border-box; border-spacing: 0px; float: left; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995itafw\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ikcuq\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i1gb7\" width=\"270\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; width: 270px;\"><table role=\"presentation\" id=\"m_-9123406524106093995imiq3\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995il4x2\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995iivri\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                                            </tr></tbody></table></td></tr></tbody></table><table id=\"m_-9123406524106093995id7lu\" cellspacing=\"0\" cellpadding=\"0\" align=\"right\" style=\"box-sizing: border-box; border-spacing: 0px; float: right; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ihfjl\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ixoyq\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995iau8b\" width=\"270\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; width: 270px;\"><table id=\"m_-9123406524106093995i82ua\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995i8jym\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995iix6r\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i9mr7\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; display: none;\">\n                                              </td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table><table id=\"m_-9123406524106093995ip144\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; width: 100%; border-collapse: collapse; table-layout: fixed;\"><tbody id=\"m_-9123406524106093995iuqxk\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i6wn7\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995isxkh\" bgcolor=\"#fafafa\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; background-color: #fafafa;\"><table id=\"m_-9123406524106093995i2t9x\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"#ffffff\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; background-color: #ffffff; width: 600px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ibxyv\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i254l\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i61da\" bgcolor=\"transparent\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; padding-left: 20px; padding-right: 20px; padding-top: 40px; background-color: transparent;\"><table id=\"m_-9123406524106093995i58tt\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995i78s7\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ieq4s\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995iilnh\" width=\"560\" valign=\"top\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; width: 560px;\"><table role=\"presentation\" id=\"m_-9123406524106093995ir4qc\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"box-sizing: border-box; border-spacing: 0px; background-position: left top; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ikz9r\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995in1e2\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i4123\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; padding-top: 5px; padding-bottom: 5px; font-size: 0;\"><div dir=\"ltr\" id=\"i47jy\" class=\"a6S\" style=\"box-sizing: border-box; opacity: 0.01; left: 763px; top: 318px;\"><div id=\":qi\" role=\"button\" tabindex=\"0\" aria-label=\"Download attachment \" data-tooltip-class=\"a1V\" data-tooltip=\"Download\" class=\"T-I J-J5-Ji aQv T-I-ax7 L3 a5q\" style=\"box-sizing: border-box;\"><div id=\"i15ut\" class=\"akn\" style=\"box-sizing: border-box;\"><div id=\"im5g3\" class=\"aSK J-J5-Ji aYr\" style=\"box-sizing: border-box;\">\n                                                      </div></div></div></div></td></tr><tr id=\"m_-9123406524106093995iz5sl\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995iczjf\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; padding-top: 15px; padding-bottom: 15px;\"><strong id=\"m_-9123406524106093995ix1fb\" style=\"box-sizing: border-box;\">Test Message Hello every one !</strong><h1 id=\"m_-9123406524106093995ikxkg\" style=\"box-sizing: border-box; Margin: 0; line-height: 24px; font-family: arial,\'helvetica neue\',helvetica,sans-serif; font-size: 20px; font-style: normal; font-weight: normal; color: #333333;\"></h1><h1 id=\"m_-9123406524106093995ip9ot\" style=\"box-sizing: border-box; Margin: 0; line-height: 24px; font-family: arial,\'helvetica neue\',helvetica,sans-serif; font-size: 20px; font-style: normal; font-weight: normal; color: #333333;\">\n                                                </h1></td></tr><tr id=\"m_-9123406524106093995iayqj\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i8h1c\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; padding-left: 40px; padding-right: 40px;\"><p id=\"m_-9123406524106093995itdic\" style=\"box-sizing: border-box; display: block; margin-top: 13px; margin-right: 0px; margin-bottom: 13px; margin-left: 0px; Margin: 0; font-family: helvetica,\'helvetica neue\',arial,verdana,sans-serif; line-height: 24px; color: #666666; font-size: 16px; text-align: center;\">HI!\n                                                </p></td></tr><tr id=\"m_-9123406524106093995isiwj\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995ijmk1\" align=\"left\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; padding-right: 35px; padding-left: 40px;\">\n                                              </td></tr><tr id=\"m_-9123406524106093995irpgg\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995imi89\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; padding-top: 25px; padding-left: 40px; padding-right: 40px;\"><p id=\"m_-9123406524106093995ieovt\" style=\"box-sizing: border-box; display: block; margin-top: 13px; margin-right: 0px; margin-bottom: 13px; margin-left: 0px; Margin: 0; font-family: helvetica,\'helvetica neue\',arial,verdana,sans-serif; line-height: 24px; color: #666666; font-size: 16px; text-align: center;\"><span draggable=\"true\" data-highlightable=\"1\" id=\"i1gs9\" class=\"im\" style=\"box-sizing: border-box;\">​​Hope you will enjoy the fly with us!!</span></p></td></tr><tr id=\"m_-9123406524106093995iwfuz\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995i9c2b\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; Margin: 0; padding-left: 10px; padding-right: 10px; padding-top: 40px; padding-bottom: 40px;\"><table id=\"m_-9123406524106093995icbql\" width=\"100%\" style=\"box-sizing: border-box; width: 100%; margin-top: 10px; margin-bottom: 10px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995ieega\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995ird2s\" style=\"box-sizing: border-box;\"><td id=\"m_-9123406524106093995ix9sw\" height=\"1\" bgcolor=\"rgba(0,0,0,0.1)\" style=\"box-sizing: border-box; border-collapse: collapse; background-color: rgba(0,0,0,0.1); height: 1px;\">\n                                                      </td></tr></tbody></table><blockquote id=\"m_-9123406524106093995ifqyl\" style=\"font-style: italic; box-sizing: border-box;\"><span id=\"m_-9123406524106093995ik0ha\" style=\"box-sizing: border-box; font-family: Georgia,serif;\"><span id=\"m_-9123406524106093995ixu03\" data-gjs-type=\"text\" draggable=\"true\" data-highlightable=\"1\" style=\"box-sizing: border-box;\">​​​​​​​</span>support&nbsp; team&nbsp;</span></blockquote></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table><table id=\"m_-9123406524106093995i0swp\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"transparent\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; width: 100%; background-color: transparent; background-repeat: repeat; background-position: center top; border-collapse: collapse; table-layout: fixed;\"><tbody id=\"m_-9123406524106093995iag5ki\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i1fvu\" style=\"box-sizing: border-box; border-collapse: collapse;\"><td id=\"m_-9123406524106093995ism9p\" bgcolor=\"#fafafa\" align=\"center\" style=\"box-sizing: border-box; border-collapse: collapse; padding: 0; Margin: 0; background-color: #fafafa;\"><table id=\"m_-9123406524106093995i131i\" width=\"600\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"transparent\" align=\"center\" style=\"box-sizing: border-box; border-spacing: 0px; background-color: transparent; width: 600px; border-collapse: collapse;\"><tbody id=\"m_-9123406524106093995iqahhi\" style=\"box-sizing: border-box;\"><tr id=\"m_-9123406524106093995i9opr\" style=\"box-sizing: border-box; border-collapse: collapse;\">\n                            </tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div>','2021-08-09 08:25:53','2021-11-06 10:29:29');
/*!40000 ALTER TABLE `templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `timezones`
--

DROP TABLE IF EXISTS `timezones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `timezones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `timezones`
--

LOCK TABLES `timezones` WRITE;
/*!40000 ALTER TABLE `timezones` DISABLE KEYS */;
INSERT INTO `timezones` VALUES (1,'Pacific/Pago_Pago','(-11:00) Pago Pago','2020-08-07 19:41:52','2020-08-07 19:41:52'),(2,'Pacific/Honolulu','(-10:00) Hawaii','2020-08-07 19:41:52','2020-08-07 19:41:52'),(3,'America/Anchorage','(-09:00) Alaska','2020-08-07 19:41:52','2020-08-07 19:41:52'),(4,'America/Vancouver','(-08:00) Canada Pacific Time','2020-08-07 19:41:52','2020-08-07 19:41:52'),(5,'America/Los_Angeles','(-08:00) US Pacific Time','2020-08-07 19:41:52','2020-08-07 19:41:52'),(6,'America/Tijuana','(-08:00) Tijuana','2020-08-07 19:41:52','2020-08-07 19:41:52'),(7,'America/Edmonton','(-07:00) Canada Mountain Time','2020-08-07 19:41:52','2020-08-07 19:41:52'),(8,'America/Denver','(-07:00) US Mountain Time','2020-08-07 19:41:52','2020-08-07 19:41:52'),(9,'America/Phoenix','(-07:00) Arizona','2020-08-07 19:41:52','2020-08-07 19:41:52'),(10,'America/Mazatlan','(-07:00) Mazatlan','2020-08-07 19:41:52','2020-08-07 19:41:52'),(11,'America/Winnipeg','(-06:00) Canada Central Time','2020-08-07 19:41:52','2020-08-07 19:41:52'),(12,'America/Regina','(-06:00) Saskatchewan','2020-08-07 19:41:52','2020-08-07 19:41:52'),(13,'America/Chicago','(-06:00) US Central Time','2020-08-07 19:41:52','2020-08-07 19:41:52'),(14,'America/Mexico_City','(-06:00) Mexico City','2020-08-07 19:41:52','2020-08-07 19:41:52'),(15,'America/Guatemala','(-06:00) Guatemala','2020-08-07 19:41:52','2020-08-07 19:41:52'),(16,'America/El_Salvador','(-06:00) El Salvador','2020-08-07 19:41:52','2020-08-07 19:41:52'),(17,'America/Managua','(-06:00) Managua','2020-08-07 19:41:52','2020-08-07 19:41:52'),(18,'America/Costa_Rica','(-06:00) Costa Rica','2020-08-07 19:41:52','2020-08-07 19:41:52'),(19,'America/Montreal','(-05:00) Canada Eastern Time','2020-08-07 19:41:52','2020-08-07 19:41:52'),(20,'America/New_York','(-05:00) US Eastern Time','2020-08-07 19:41:52','2020-08-07 19:41:52'),(21,'America/Indianapolis','(-05:00) East Indiana','2020-08-07 19:41:52','2020-08-07 19:41:52'),(22,'America/Panama','(-05:00) Panama','2020-08-07 19:41:52','2020-08-07 19:41:52'),(23,'America/Bogota','(-05:00) Bogota','2020-08-07 19:41:52','2020-08-07 19:41:52'),(24,'America/Lima','(-05:00) Lima','2020-08-07 19:41:52','2020-08-07 19:41:52'),(25,'America/Halifax','(-04:00) Canada Atlantic Time','2020-08-07 19:41:52','2020-08-07 19:41:52'),(26,'America/Puerto_Rico','(-04:00) Puerto Rico','2020-08-07 19:41:52','2020-08-07 19:41:52'),(27,'America/Caracas','(-04:00) Caracas','2020-08-07 19:41:52','2020-08-07 19:41:52'),(28,'America/Santiago','(-04:00) Santiago','2020-08-07 19:41:52','2020-08-07 19:41:52'),(29,'America/St_Johns','(-03:30) Newfoundland','2020-08-07 19:41:52','2020-08-07 19:41:52'),(30,'America/Sao_Paulo','(-03:00) Sao Paulo','2020-08-07 19:41:52','2020-08-07 19:41:52'),(31,'Atlantic/Azores','(-01:00) Azores','2020-08-07 19:41:52','2020-08-07 19:41:52'),(32,'UTC','(00:00) Universal Time','2020-08-07 19:41:52','2020-08-07 19:41:52'),(33,'Atlantic/Reykjavik','(00:00) Reykjavik','2020-08-07 19:41:52','2020-08-07 19:41:52'),(34,'Europe/Dublin','(00:00) Dublin','2020-08-07 19:41:52','2020-08-07 19:41:52'),(35,'Europe/London','(00:00) London','2020-08-07 19:41:52','2020-08-07 19:41:52'),(36,'Europe/Lisbon','(00:00) Lisbon','2020-08-07 19:41:52','2020-08-07 19:41:52'),(37,'Africa/Casablanca','(00:00) Casablanca','2020-08-07 19:41:52','2020-08-07 19:41:52'),(38,'Africa/Nouakchott','(00:00) Nouakchott','2020-08-07 19:41:52','2020-08-07 19:41:52'),(39,'Europe/Oslo','(+01:00) Oslo','2020-08-07 19:41:52','2020-08-07 19:41:52'),(40,'Europe/Stockholm','(+01:00) Stockholm','2020-08-07 19:41:52','2020-08-07 19:41:52'),(41,'Europe/Copenhagen','(+01:00) Copenhagen','2020-08-07 19:41:52','2020-08-07 19:41:52'),(42,'Europe/Berlin','(+01:00) Berlin','2020-08-07 19:41:52','2020-08-07 19:41:52'),(43,'Europe/Amsterdam','(+01:00) Amsterdam','2020-08-07 19:41:52','2020-08-07 19:41:52'),(44,'Europe/Brussels','(+01:00) Brussels','2020-08-07 19:41:52','2020-08-07 19:41:52'),(45,'Europe/Luxembourg','(+01:00) Luxembourg','2020-08-07 19:41:52','2020-08-07 19:41:52'),(46,'Europe/Paris','(+01:00) Paris','2020-08-07 19:41:52','2020-08-07 19:41:52'),(47,'Europe/Zurich','(+01:00) Zurich','2020-08-07 19:41:52','2020-08-07 19:41:52'),(48,'Europe/Madrid','(+01:00) Madrid','2020-08-07 19:41:52','2020-08-07 19:41:52'),(49,'Europe/Rome','(+01:00) Rome','2020-08-07 19:41:52','2020-08-07 19:41:52'),(50,'Africa/Algiers','(+01:00) Algiers','2020-08-07 19:41:52','2020-08-07 19:41:52'),(51,'Africa/Tunis','(+01:00) Tunis','2020-08-07 19:41:52','2020-08-07 19:41:52'),(52,'Europe/Warsaw','(+01:00) Warsaw','2020-08-07 19:41:52','2020-08-07 19:41:52'),(53,'Europe/Prague','(+01:00) Prague Bratislava','2020-08-07 19:41:52','2020-08-07 19:41:52'),(54,'Europe/Vienna','(+01:00) Vienna','2020-08-07 19:41:52','2020-08-07 19:41:52'),(55,'Europe/Budapest','(+01:00) Budapest','2020-08-07 19:41:52','2020-08-07 19:41:52'),(56,'Europe/Sofia','(+02:00) Sofia','2020-08-07 19:41:52','2020-08-07 19:41:52'),(57,'Europe/Istanbul','(+02:00) Istanbul','2020-08-07 19:41:52','2020-08-07 19:41:52'),(58,'Europe/Athens','(+02:00) Athens','2020-08-07 19:41:52','2020-08-07 19:41:52'),(59,'Asia/Nicosia','(+02:00) Nicosia','2020-08-07 19:41:52','2020-08-07 19:41:52'),(60,'Asia/Beirut','(+02:00) Beirut','2020-08-07 19:41:52','2020-08-07 19:41:52'),(61,'Asia/Damascus','(+02:00) Damascus','2020-08-07 19:41:52','2020-08-07 19:41:52'),(62,'Asia/Jerusalem','(+02:00) Jerusalem','2020-08-07 19:41:52','2020-08-07 19:41:52'),(63,'Asia/Amman','(+02:00) Amman','2020-08-07 19:41:52','2020-08-07 19:41:52'),(64,'Africa/Tripoli','(+02:00) Tripoli','2020-08-07 19:41:52','2020-08-07 19:41:52'),(65,'Africa/Cairo','(+02:00) Cairo','2020-08-07 19:41:52','2020-08-07 19:41:52'),(66,'Africa/Johannesburg','(+02:00) Johannesburg','2020-08-07 19:41:52','2020-08-07 19:41:52'),(67,'Europe/Moscow','(+03:00) Moscow','2020-08-07 19:41:52','2020-08-07 19:41:52'),(68,'Asia/Baghdad','(+03:00) Baghdad','2020-08-07 19:41:52','2020-08-07 19:41:52'),(69,'Asia/Kuwait','(+03:00) Kuwait','2020-08-07 19:41:52','2020-08-07 19:41:52'),(70,'Asia/Riyadh','(+03:00) Riyadh','2020-08-07 19:41:52','2020-08-07 19:41:52'),(71,'Asia/Bahrain','(+03:00) Bahrain','2020-08-07 19:41:52','2020-08-07 19:41:52'),(72,'Asia/Qatar','(+03:00) Qatar','2020-08-07 19:41:52','2020-08-07 19:41:52'),(73,'Asia/Aden','(+03:00) Aden','2020-08-07 19:41:52','2020-08-07 19:41:52'),(74,'Africa/Khartoum','(+03:00) Khartoum','2020-08-07 19:41:52','2020-08-07 19:41:52'),(75,'Africa/Djibouti','(+03:00) Djibouti','2020-08-07 19:41:52','2020-08-07 19:41:52'),(76,'Africa/Mogadishu','(+03:00) Mogadishu','2020-08-07 19:41:52','2020-08-07 19:41:52'),(77,'Asia/Dubai','(+04:00) Dubai','2020-08-07 19:41:52','2020-08-07 19:41:52'),(78,'Asia/Muscat','(+04:00) Muscat','2020-08-07 19:41:52','2020-08-07 19:41:52'),(79,'Asia/Yekaterinburg','(+05:00) Yekaterinburg','2020-08-07 19:41:52','2020-08-07 19:41:52'),(80,'Asia/Tashkent','(+05:00) Tashkent','2020-08-07 19:41:52','2020-08-07 19:41:52'),(81,'Asia/Calcutta','(+05:30) India','2020-08-07 19:41:52','2020-08-07 19:41:52'),(82,'Asia/Novosibirsk','(+06:00) Novosibirsk','2020-08-07 19:41:52','2020-08-07 19:41:52'),(83,'Asia/Almaty','(+06:00) Almaty','2020-08-07 19:41:52','2020-08-07 19:41:52'),(84,'Asia/Dacca','(+06:00) Dacca','2020-08-07 19:41:52','2020-08-07 19:41:52'),(85,'Asia/Krasnoyarsk','(+07:00) Krasnoyarsk','2020-08-07 19:41:52','2020-08-07 19:41:52'),(86,'Asia/Bangkok','(+07:00) Bangkok','2020-08-07 19:41:52','2020-08-07 19:41:52'),(87,'Asia/Saigon','(+07:00) Vietnam','2020-08-07 19:41:52','2020-08-07 19:41:52'),(88,'Asia/Jakarta','(+07:00) Jakarta','2020-08-07 19:41:52','2020-08-07 19:41:52'),(89,'Asia/Irkutsk','(+08:00) Irkutsk','2020-08-07 19:41:52','2020-08-07 19:41:52'),(90,'Asia/Shanghai','(+08:00) Beijing, Shanghai','2020-08-07 19:41:52','2020-08-07 19:41:52'),(91,'Asia/Hong_Kong','(+08:00) Hong Kong','2020-08-07 19:41:52','2020-08-07 19:41:52'),(92,'Asia/Taipei','(+08:00) Taipei','2020-08-07 19:41:52','2020-08-07 19:41:52'),(93,'Asia/Kuala_Lumpur','(+08:00) Kuala Lumpur','2020-08-07 19:41:52','2020-08-07 19:41:52'),(94,'Asia/Singapore','(+08:00) Singapore','2020-08-07 19:41:52','2020-08-07 19:41:52'),(95,'Australia/Perth','(+08:00) Perth','2020-08-07 19:41:52','2020-08-07 19:41:52'),(96,'Asia/Yakutsk','(+09:00) Yakutsk','2020-08-07 19:41:52','2020-08-07 19:41:52'),(97,'Asia/Seoul','(+09:00) Seoul','2020-08-07 19:41:52','2020-08-07 19:41:52'),(98,'Asia/Tokyo','(+09:00) Tokyo','2020-08-07 19:41:52','2020-08-07 19:41:52'),(99,'Australia/Darwin','(+09:30) Darwin','2020-08-07 19:41:52','2020-08-07 19:41:52'),(100,'Australia/Adelaide','(+09:30) Adelaide','2020-08-07 19:41:52','2020-08-07 19:41:52'),(101,'Asia/Vladivostok','(+10:00) Vladivostok','2020-08-07 19:41:52','2020-08-07 19:41:52'),(102,'Australia/Brisbane','(+10:00) Brisbane','2020-08-07 19:41:52','2020-08-07 19:41:52'),(103,'Australia/Sydney','(+10:00) Sydney Canberra','2020-08-07 19:41:52','2020-08-07 19:41:52'),(104,'Australia/Hobart','(+10:00) Hobart','2020-08-07 19:41:52','2020-08-07 19:41:52'),(105,'Asia/Magadan','(+11:00) Magadan','2020-08-07 19:41:52','2020-08-07 19:41:52'),(106,'Asia/Kamchatka','(+12:00) Kamchatka','2020-08-07 19:41:52','2020-08-07 19:41:52'),(107,'Pacific/Auckland','(+12:00) Auckland','2020-08-07 19:41:52','2020-08-07 19:41:52'),(108,'Asia/Nepal','(+05:45) Nepal','2020-08-09 11:41:30','2020-08-09 11:41:30');
/*!40000 ALTER TABLE `timezones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `licence` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `timezone` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'UTC',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `domain` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'dashboard/assets/images/logo-icon.png',
  `company_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'dashboard/assets/images/favicon.png',
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `api_token` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang` varchar(50) CHARACTER SET utf8 NOT NULL DEFAULT 'English - English',
  `tstamp` int(20) NOT NULL DEFAULT '0',
  `loadb_type` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'put-your-license','admin','Africa/Cairo','','demo.vdopanel.com','uploads/logos/1601892297.png','VDO Panel','uploads/icons/1595445108.png',NULL,'null',NULL,NULL,'English - English',1622638136,1,'2020-06-26 23:46:16','2020-10-16 11:43:34');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `videos`
--

DROP TABLE IF EXISTS `videos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `videos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `playlist_id` int(11) NOT NULL,
  `broadcaster_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `file` varchar(255) NOT NULL,
  `position` int(11) NOT NULL DEFAULT '0',
  `duration` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `playlist_id` (`playlist_id`),
  KEY `broadcaster_id` (`broadcaster_id`),
  CONSTRAINT `brodfk` FOREIGN KEY (`broadcaster_id`) REFERENCES `broadcasters` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `paly_list_f` FOREIGN KEY (`playlist_id`) REFERENCES `playlists` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `videos`
--

LOCK TABLES `videos` WRITE;
/*!40000 ALTER TABLE `videos` DISABLE KEYS */;
/*!40000 ALTER TABLE `videos` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2021-11-06 12:33:45
